package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.app.Dialog
import android.graphics.Color
import android.os.Bundle
import android.util.Log
import android.view.Gravity
import android.view.View
import android.view.Window
import android.view.WindowManager
import android.view.animation.AccelerateInterpolator
import android.view.animation.DecelerateInterpolator
import android.widget.EditText
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.graphics.drawable.toDrawable
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.burhanstore.neonbubblequest.AppConst
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.adapter.AmountAdapter
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.model.PaymentModel
import com.burhanstore.neonbubblequest.Utils.network.AppNetworkAdapter
import com.burhanstore.neonbubblequest.Utils.response.PaymentResponse
import com.burhanstore.neonbubblequest.Utils.response.SplashResponse
import com.burhanstore.neonbubblequest.databinding.ActivityRedeemViewBinding
import com.google.gson.Gson
import com.google.gson.JsonObject
import kotlinx.coroutines.launch

class RedeemViewActivity : AppCompatActivity() {
    private lateinit var binding: ActivityRedeemViewBinding
    private lateinit var activity: Activity
    private lateinit var manager: UserManager
    private var py_title: String = ""
    private var uid: String = ""
    private var item_id: Int = 0
    private var py_rcoin: String = ""
    private var py_amout: String = ""
    private var py_currency: String = ""
    private var py_inouthint: String = ""
    private var py_inputhint2: String = ""
    private var py_logo: String = ""

    private var dialog_redeem: Dialog? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityRedeemViewBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this


        manager = UserManager.getInstance(activity)
        uid = manager.getUser()?.u_id ?: ""
        DialogManager.initDialog(activity)

        py_title = intent.getStringExtra("py_title").toString()
        item_id = intent.getIntExtra("item_id", 0)
        py_rcoin = intent.getStringExtra("py_rcoin").toString()
        py_amout = intent.getStringExtra("py_amout").toString()
        py_currency = intent.getStringExtra("py_currency").toString()
        py_inouthint = intent.getStringExtra("py_inouthint").toString()
        py_inputhint2 = intent.getStringExtra("py_inputhint2").toString()
        py_logo = intent.getStringExtra("py_logo").toString()

        binding.imageView2.setClick {
            finish()
        }



        get_amount()


    }


    private fun get_amount() {
        val json = JsonObject().apply {
            addProperty("action", "get_amountpy")
            addProperty("u_id", uid)
            addProperty("item_id", item_id)
        }
        AppNetworkAdapter.sendRequest(
            lifecycleScope,
            json,
            object : AppNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("QuickBonus", "Success: $response")

                    lifecycleScope.launch {
                        try {
                            val quickBonusResponse =
                                Gson().fromJson(response, PaymentResponse::class.java)
                            val data = quickBonusResponse.payment

                            val dbUser = quickBonusResponse.user

                            AppConst.setString(
                                activity, AppConst.USER_COIN, dbUser.point ?: "0"
                            )

                            update_quiz(data)
                        } catch (e: Exception) {
                            Log.e("QuickBonus", "Parsing error: ${e.message}")
                        }
                    }
                }

                override fun onError(code: Int, message: String?) {
                    Log.e("QuickBonus", "Error $code: $message")
                }

                override fun onException(exception: Exception) {
                    Log.e("QuickBonus", "Exception: ", exception)
                }
            }


        )

    }


    private fun update_quiz(data: List<PaymentModel>) {
        binding.coinsTextview.text = AppConst.getString(this, AppConst.USER_COIN)
        val userCoin = AppConst.getString(this, AppConst.USER_COIN).toIntOrNull() ?: 0
        // Vertical LinearLayoutManager
        binding.redeemList.layoutManager =
            LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false)
        binding.redeemList.adapter =
            AmountAdapter(data, py_currency, py_logo, py_title) { paymentItem ->
                val requiredCoin = paymentItem.py_rcoin.toIntOrNull() ?: 0

                if (userCoin >= requiredCoin) {
                    redeem_inputDialog(
                        py_title,
                        paymentItem.py_rcoin,
                        paymentItem.py_amout,
                        py_currency,
                        py_inouthint,
                        py_inputhint2
                    )


                } else {
                    Toast.makeText(
                        this,
                        "Insufficient coins. You have $userCoin, but need $requiredCoin",
                        Toast.LENGTH_SHORT
                    ).show()
                }

            }
    }


    private fun redeem_inputDialog(
        py_title: String,
        py_rcoin: String,
        py_amout: String,
        py_currency: String,
        py_inouthint: String,
        py_inputhint2: String
    ) {

        dialog_redeem = Dialog(activity).apply {
            requestWindowFeature(Window.FEATURE_NO_TITLE)
            setContentView(R.layout.redeem_input_dialog)
            setCancelable(true)
            window?.apply {
                setBackgroundDrawable(Color.TRANSPARENT.toDrawable())
                setGravity(Gravity.BOTTOM)
                attributes = attributes?.apply {
                    width = WindowManager.LayoutParams.MATCH_PARENT
                    height = WindowManager.LayoutParams.WRAP_CONTENT
                }
                addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
                setDimAmount(0.4f)
            }
        }

        val rootView = dialog_redeem?.findViewById<View>(R.id.dialog_root)
        val closeBtn = dialog_redeem?.findViewById<LinearLayout>(R.id.closeBtn)
        val sendBtn = dialog_redeem?.findViewById<LinearLayout>(R.id.sendBtn)
        val input1 = dialog_redeem?.findViewById<EditText>(R.id.input1)
        val input2 = dialog_redeem?.findViewById<EditText>(R.id.input2)
        val title = dialog_redeem?.findViewById<TextView>(R.id.title)


        input1?.hint = py_inouthint
        input2?.hint = py_inputhint2
        title?.text = py_title + " " + py_currency + py_amout



        rootView?.apply {
            translationY = 300f
            alpha = 0f
            animate()
                .translationY(0f)
                .alpha(1f)
                .setDuration(400)
                .setInterpolator(DecelerateInterpolator())
                .start()
        }


        input1

        sendBtn?.setClick {
            val inputText1 = input1?.text.toString().trim()
            val inputText2 = input2?.text.toString().trim()
            if (inputText1.isEmpty()) {
                Toast.makeText(activity, "Please enter a value", Toast.LENGTH_SHORT).show()
            } else if (inputText2.isEmpty()) {
                Toast.makeText(activity, "Please enter a value", Toast.LENGTH_SHORT).show()
            } else {
                rootView?.animate()
                    ?.translationY(300f)
                    ?.alpha(0f)
                    ?.setDuration(300)
                    ?.setInterpolator(AccelerateInterpolator())
                    ?.withEndAction { dialog_redeem!!.dismiss() }
                    ?.start()
                DialogManager.showDialog()
                sendRedeem_req(
                    py_title,
                    py_rcoin,
                    py_amout,
                    py_currency,
                    inputText1,
                    inputText2
                )
            }
        }

        closeBtn?.setClick {
            rootView?.animate()
                ?.translationY(300f)
                ?.alpha(0f)
                ?.setDuration(300)
                ?.setInterpolator(AccelerateInterpolator())
                ?.withEndAction { dialog_redeem!!.dismiss() }
                ?.start()
        }


        // Show dialog safely
        runCatching {
            dialog_redeem?.isShowing?.let { if (!it) dialog_redeem!!.show() }
        }.onFailure { it.printStackTrace() }


    }


    private fun sendRedeem_req(
        py_title: String,
        py_rcoin: String,
        py_amout: String,
        py_currency: String,
        op1: String,
        op2: String
    ) {

        val json = JsonObject().apply {
            addProperty("action", "send_redeem_request")
            addProperty("uid", uid)
            addProperty("name", manager.getUser()?.name)
            addProperty("op1", op1)
            addProperty("op2", op2)
            addProperty("py_title", py_title)
            addProperty("py_rcoin", py_rcoin)
            addProperty("py_amout", py_amout)
            addProperty("py_currency", py_currency)
        }

        AppNetworkAdapter.sendRequest(
            lifecycleScope,
            json,
            object : AppNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("SplashActivity", "Success: $response")

                    val req_response = Gson().fromJson(response, SplashResponse::class.java)
                    val user = req_response.user
                    Toast.makeText(activity, "${req_response.message}", Toast.LENGTH_SHORT).show()


                    if (user != null) {
                        manager.saveUser(user)
                        AppConst.setString(
                            activity, AppConst.USER_COIN,
                            manager.getUser()?.point ?: "0"
                        )


                    }

                    binding.coinsTextview.text = AppConst.getString(activity, AppConst.USER_COIN)


                    DialogManager.redeem_Success(activity)
                    DialogManager.dismissDialog()


                }

                override fun onError(code: Int, message: String?) {
                    Log.e("SplashActivity", "Error $code: $message")
                    DialogManager.dismissDialog()
                    Toast.makeText(activity, "$message", Toast.LENGTH_SHORT).show()
                }

                override fun onException(exception: Exception) {
                    Log.e("SplashActivity", "Exception: ", exception)
                    DialogManager.dismissDialog()

                }
            })

    }


}